<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Setting;

trait TraitSettingGetters
{
    use TraitSettingProperties;

    /*
    |--------------------------------------------------------------------------
    | Note! We could have all our properties as public. The reason for using 
    | getters is that static checking doesn't work well for undefined properties
    | because of dynamic properties in PHP(__set & __get methods)
    |--------------------------------------------------------------------------
    */

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getKey(): string
    {
        return $this -> key;
    }

    public function getValue(): string
    {
        return $this -> value;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
